<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );



// Custome CSS For Admin Panel
function custom_admin_css() {
    echo '<style>
        /* Your custom CSS rules go here */
#order_data .order_data_column:last-child{
		display:none;
		}

@media only screen and (max-width: 1280px){
#order_data .order_data_column {
    width: 100% !important;
}}
#order_data .order_data_column ._billing_last_name_field, #order_data .order_data_column ._billing_company_field, #order_data .order_data_column ._billing_address_2_field, #order_data .order_data_column ._billing_city_field, #order_data .order_data_column ._billing_postcode_field, #order_data .order_data_column_container p._billing_email_field, #order_data .order_data_column ._transaction_id_field, #order_data .order_data_column ._billing_country_field, #order_data .order_data_column ._billing_state_field{
display:none !important;
}
#order_data .order_data_column ._billing_first_name_field, #order_data .order_data_column ._billing_address_1_field, #order_data .order_data_column ._billing_phone_field, #order_data .order_data_column ._billing_state_field{
width:100% !important;
}

.column-pathao .ptc-open-modal-button {
    cursor: pointer;
    height: 50px;
    padding: 0 8px;
    background: #339933;
    color: #fff;
    font-weight: 500;
}
        /* Add more CSS rules as needed */
    </style>';
}
add_action('admin_enqueue_scripts', 'custom_admin_css');





/**
 * Default order status To Panding
 */

add_filter( 'woocommerce_cod_process_payment_order_status', 'change_cod_payment_order_status', 10, 2 );
function change_cod_payment_order_status( $order_status, $order ) {
    return 'pending';
}

add_filter('woocommerce_billing_fields', function($fields) {
    if (isset($fields['billing_email'])) {
        $fields['billing_email']['required'] = false; // ইমেইল ফিল্ড অপশনাল করুন
    }
    return $fields;
});


/**
 * Registration Page Rederect
 */
function custom_registration_redirect() {
    if ( is_multisite() && $_SERVER['REQUEST_URI'] === '/wp-login.php?action=register' ) {
        wp_redirect( site_url('/register') );
        exit;
    }
}
add_action('init', 'custom_registration_redirect');

